/*------------------------------------------------------------------------------*
 * File Name: SubsequentlyProcessGetNTree.c										*
 * Creation: GJL 6/24/2003														*
 * Purpose: Origin C file containing GetNBox example codes.						*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <GetNBox.h>

void SubsequentlyProcessGetNTree()
{
	// Use GETN_TREE macro to declare a tree for a Tree style GetN dialog
	GETN_TREE(tr)

	// Add a numeric edit box node named Days having caption "Enter Days:"
	// initialized to numeric value 0
	GETN_NUM(Days, "Enter Days:", 0)

	// Add a numeric edit box node named Hours having caption "Enter Hours:"
	// initialized to numeric value 0
	GETN_NUM(Hours, "Enter Hours:", 0)

	// Add a numeric edit box node named Minutes having caption "Enter Minutes:"
	// initialized to numeric value 0
	GETN_NUM(Minutes, "Enter Minutes:", 0)

	// Add a numeric edit box node named Seconds having caption "Enter Seconds:"
	// initialized to numeric value 0
	GETN_NUM(Seconds, "Enter Seconds:", 0)

	// Open GetNBox dialog passing GetN tree name tr and having dialog title
	// "Compute Elapsed Seconds"
	if( GetNBox(tr, "Compute Elapsed Seconds") ) // If user clicks OK GetNBox function returns true
	{
		// Process GetN tree values computing elapsed seconds
		if( ComputeElapsedSeconds(tr) ) // If elapsed seconds computation is successful...
			printf("%g Days + %g Hours + %g Minutes + %g Seconds = %g Seconds\n",
					tr.Days.dVal,
					tr.Hours.dVal,
					tr.Minutes.dVal,
					tr.Seconds.dVal,
					tr.ElapsedSeconds.dVal
			); // Output elapsed seconds
	}
	// Else if user clicks Cancel button GetNBox function returns false so do not process
}

// Function to process an input GetN tree named tr computing elapsed seconds from nodes Days,
// Hours, Minutes, and Seconds and storing result in newly created node named ElapsedSeconds
bool ComputeElapsedSeconds(TreeNode &tr)
{
	tr.ElapsedSeconds.dVal  =	tr.Days.dVal * 24 * 60 * 60 + 
				tr.Hours.dVal * 60 * 60 +
				tr.Minutes.dVal * 60 +
				tr.Seconds.dVal;
	return true;
}
